Drupal.behaviors.mee = function(context) {
  $("div.mee-wrap-editor-library:not(.mee-processed)")
    .addClass('mee-processed')
    .find('> div.dnd-library-wrapper')
    .each(function() {
      var $editor = $('#' + this.id.slice(0, -12)); 
      $editor.bind('wysiwygAttach', Drupal.mee.attach);
      $editor.bind('wysiwygDetach', Drupal.mee.detach);
    })
    .end()
}

Drupal.mee = {
  attach: function(e, data) {
    var t = setInterval(function() {
      var tiny_instance = tinyMCE.getInstanceById(data.field);
      if (tiny_instance) {
        clearInterval(t);
        $(tiny_instance.editor_id)
          .find('iframe')
          .unbind('dnd_drop')
          .bind('dnd_drop', function(e, data) {
            var rep = Drupal.settings.dndEditorRepresentations[data.representation_id];
            $(this)
              .parents('div.mee-wrap-editor-library.mee-processed')
              .find('table.mee-ressource-manager')
              .each(function(i) {
                $(this).append(Drupal.mee.generate(
                  rep.title,
                  Drupal.tableDrag[this.id]
                ));
              });
          });
      }
    }, 100);
  },
  detach: function(e, data) {

  },
  generate: function(title, tableDrag) {
    var $select = $("<select />"), $tr = $('<tr />'), $td = $("<td />");
    $tr
      .addClass('draggable')
      .append($('<td></td>'))
      .append($('<td></td>').append(title));
    for (var i = -10; i <= 10; i++) {
      $select.append("<option>"+ i +"</option>");
    }
    $select.val(0).addClass('mee-rm-weight');
    $td.append($select);
    $tr.append($td);
    tableDrag.makeDraggable($tr);
    return $tr;
  }
}
